/*
 * Decompiled with CFR 0.152.
 */
package hsbogi.transform;

import Jama.Matrix;
import hsbogi.transform.Transform2D;
import java.awt.geom.AffineTransform;

public class BilinearTransform
extends Transform2D {
    private static double eps = 1.0E-15;
    double[][] a = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
    BilinearTransform inverse = null;
    boolean changed = false;

    public BilinearTransform() {
    }

    public BilinearTransform(double a00, double a10, double a01, double a11, double a02, double a12, double a03, double a13) {
        this.a = new double[][]{{a00, a01, a02, a03}, {a10, a11, a12, a13}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
        this.changed = true;
    }

    public BilinearTransform(double a00, double a10, double a01, double a11, double a02, double a12) {
        this.a = new double[][]{{a00, a01, a02, 0.0}, {a10, a11, a12, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
        this.changed = true;
    }

    public BilinearTransform(double a00, double a10, double a02, double a12) {
        this.a = new double[][]{{a00, -a10, a02, 0.0}, {a10, a00, a12, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
        this.changed = true;
    }

    public static BilinearTransform create(AffineTransform at) {
        double[] a = new double[6];
        at.getMatrix(a);
        return new BilinearTransform(a[0], a[1], a[2], a[3], a[4], a[5]);
    }

    public void concatenate(BilinearTransform trans) {
        Matrix mtrans = new Matrix(trans.a);
        Matrix mthis = new Matrix(this.a);
        Matrix result = mtrans.times(mthis);
        this.a = result.getArray();
        this.changed = true;
    }

    public void translate(double tx, double ty) {
        BilinearTransform trans = new BilinearTransform(new double[][]{{1.0, 0.0, tx, 0.0}, {0.0, 1.0, ty, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}});
        this.concatenate(trans);
    }

    public void scale(double mx, double my) {
        BilinearTransform trans = new BilinearTransform(new double[][]{{mx, 0.0, 0.0, 0.0}, {0.0, my, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}});
        this.concatenate(trans);
    }

    public void rotate(double rx, double ry) {
        BilinearTransform trans = new BilinearTransform(new double[][]{{Math.cos(rx), -Math.sin(rx), 0.0, 0.0}, {Math.sin(ry), Math.cos(ry), 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}});
        this.concatenate(trans);
    }

    public void rotate(double r, double x, double y) {
        this.translate(-x, -y);
        this.rotate(r, r);
        this.translate(x, y);
    }

    public void shear(double sx, double sy) {
        BilinearTransform trans = new BilinearTransform(new double[][]{{1.0, sx, 0.0, 0.0}, {sy, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}});
        this.concatenate(trans);
    }

    public void converge(double bx, double by) {
        BilinearTransform trans = new BilinearTransform(new double[][]{{1.0, 0.0, 0.0, bx}, {0.0, 1.0, 0.0, by}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}});
        this.concatenate(trans);
    }

    public AffineTransform toAffineTransform() {
        AffineTransform at = new AffineTransform();
        at.setTransform(this.a[0][0], this.a[1][0], this.a[0][1], this.a[1][1], this.a[0][2], this.a[1][2]);
        return at;
    }

    @Override
    public double[] transform(double x, double y) {
        double[] dst = new double[]{this.a[0][0] * x + this.a[0][1] * y + this.a[0][2] + this.a[0][3] * x * y, this.a[1][0] * x + this.a[1][1] * y + this.a[1][2] + this.a[1][3] * x * y};
        return dst;
    }

    @Override
    public double[] inverseTransform(double x, double y) {
        double dv;
        double du;
        if (this.changed) {
            this.inverseMatrix();
        }
        double[] src = this.inverse.transform(x, y);
        if (Math.abs(this.a[0][3]) < eps && Math.abs(this.a[1][3]) < eps) {
            return src;
        }
        double u = src[0];
        double v = src[1];
        boolean flag = true;
        do {
            double[] dst = this.transform(u, v);
            double x0 = dst[0];
            double y0 = dst[1];
            double dx = x - x0;
            double dy = y - y0;
            double[][] delta = new double[][]{{this.a[0][0] + this.a[0][3] * v, this.a[0][1] + this.a[0][3] * u}, {this.a[1][0] + this.a[1][3] * v, this.a[1][1] + this.a[1][3] * u}};
            Matrix mDelta = new Matrix(delta);
            Matrix mDxy = new Matrix(new double[][]{{dx}, {dy}});
            Matrix mDuv = mDelta.solve(mDxy);
            double[] duv = mDuv.getColumnPackedCopy();
            du = duv[0];
            dv = duv[1];
            v += dv;
        } while (flag = Math.abs(du / (u += du)) > eps || Math.abs(dv / v) > eps);
        return new double[]{u, v};
    }

    public String toString() {
        String s = "";
        int i = 0;
        while (i < this.a.length) {
            s = String.valueOf(s) + "[" + this.rnd(this.a[i][0]) + " " + this.rnd(this.a[i][1]) + " " + this.rnd(this.a[i][2]) + " " + this.rnd(this.a[i][3]) + "]\n";
            ++i;
        }
        return s;
    }

    private BilinearTransform(double[][] a) {
        this.a = a;
        this.changed = true;
    }

    private double rnd(double x) {
        return Math.rint(x / eps) * eps;
    }

    private void inverseMatrix() {
        Matrix A = new Matrix(this.a);
        Matrix Ac = new Matrix(A.getArrayCopy());
        Ac.set(0, 3, 0.0);
        Ac.set(1, 3, 0.0);
        Matrix INV = Ac.inverse();
        this.inverse = new BilinearTransform(INV.getArray());
        this.changed = false;
    }
}

