/*
 * Decompiled with CFR 0.152.
 */
package hsbogi.transform;

import java.awt.Shape;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;

public abstract class Transform2D {
    public Shape transform(Shape s) {
        PathIterator pi = s.getPathIterator(null);
        Path2D.Double p = new Path2D.Double();
        double[] src = new double[6];
        double[] dst = new double[6];
        while (!pi.isDone()) {
            int type = pi.currentSegment(src);
            dst = this.transform(src);
            if (type == 0) {
                ((Path2D)p).moveTo(dst[0], dst[1]);
            } else if (type == 1) {
                ((Path2D)p).lineTo(dst[0], dst[1]);
            } else if (type == 2) {
                ((Path2D)p).quadTo(dst[0], dst[1], dst[2], dst[3]);
            } else if (type == 3) {
                ((Path2D)p).curveTo(dst[0], dst[1], dst[2], dst[3], dst[4], dst[5]);
            } else if (type == 4) {
                p.closePath();
            }
            pi.next();
        }
        return p;
    }

    public Shape inverseTransform(Shape s) {
        PathIterator pi = s.getPathIterator(null);
        Path2D.Double p = new Path2D.Double();
        double[] src = new double[6];
        double[] dst = new double[6];
        while (!pi.isDone()) {
            int type = pi.currentSegment(src);
            dst = this.transform(src);
            if (type == 0) {
                ((Path2D)p).moveTo(dst[0], dst[1]);
            } else if (type == 1) {
                ((Path2D)p).lineTo(dst[0], dst[1]);
            } else if (type == 2) {
                ((Path2D)p).quadTo(dst[0], dst[1], dst[2], dst[3]);
            } else if (type == 3) {
                ((Path2D)p).curveTo(dst[0], dst[1], dst[2], dst[3], dst[4], dst[5]);
            } else if (type == 4) {
                p.closePath();
            }
            pi.next();
        }
        return p;
    }

    public Point2D transform(Point2D point) {
        double[] coords = this.transform(point.getX(), point.getY());
        return new Point2D.Double(coords[0], coords[1]);
    }

    public Point2D inverseTransform(Point2D point) {
        double[] coords = this.inverseTransform(point.getX(), point.getY());
        return new Point2D.Double(coords[0], coords[1]);
    }

    public double[] transform(double[] srcPts) {
        double[] dstPts = new double[srcPts.length];
        int srcOff = 0;
        int dstOff = 0;
        int numPts = srcPts.length / 2;
        while (numPts > 0) {
            double x = srcPts[srcOff++];
            double y = srcPts[srcOff++];
            double[] result = this.transform(x, y);
            dstPts[dstOff++] = result[0];
            dstPts[dstOff++] = result[1];
            --numPts;
        }
        return dstPts;
    }

    public double[] inverseTransform(double[] srcPts) {
        double[] dstPts = new double[srcPts.length];
        int srcOff = 0;
        int dstOff = 0;
        int numPts = srcPts.length / 2;
        while (numPts > 0) {
            double x = srcPts[srcOff++];
            double y = srcPts[srcOff++];
            double[] result = this.inverseTransform(x, y);
            dstPts[dstOff++] = result[0];
            dstPts[dstOff++] = result[1];
            --numPts;
        }
        return dstPts;
    }

    public abstract double[] transform(double var1, double var3);

    public abstract double[] inverseTransform(double var1, double var3);
}

