/*
 * Decompiled with CFR 0.152.
 */
package hsbogi.transform;

import Jama.Matrix;

public class Transform2hD {
    private static double eps = 1.0E-15;
    public static int PROJ_NONE = 0;
    public static int PROJ_PARALLEL = 1;
    public static int PROJ_CENTRAL = 2;
    public static int PROJ_OPTICAL = 3;
    double[][] a = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
    Transform2hD inverse = null;
    int projection = 0;
    boolean changed = false;

    public Transform2hD() {
    }

    private Transform2hD(double[][] a) {
        this.a = a;
        this.changed = true;
    }

    public void concatenate(Transform2hD trans) {
        Matrix mtrans = new Matrix(trans.a);
        Matrix mthis = new Matrix(this.a);
        Matrix result = mtrans.times(mthis);
        this.a = result.getArray();
        this.changed = true;
    }

    public void translate(double tx, double ty, double tz) {
        Transform2hD trans = new Transform2hD(new double[][]{{1.0, 0.0, 0.0, tx}, {0.0, 1.0, 0.0, ty}, {0.0, 0.0, 1.0, tz}, {0.0, 0.0, 0.0, 1.0}});
        this.concatenate(trans);
    }

    public void rotateX(double rx) {
        Transform2hD trans = new Transform2hD(new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, Math.cos(rx), -Math.sin(rx), 0.0}, {0.0, Math.sin(rx), Math.cos(rx), 0.0}, {0.0, 0.0, 0.0, 1.0}});
        this.concatenate(trans);
    }

    public void rotateY(double ry) {
        Transform2hD trans = new Transform2hD(new double[][]{{Math.cos(ry), 0.0, Math.sin(ry), 0.0}, {0.0, 1.0, 0.0, 0.0}, {-Math.sin(ry), 0.0, Math.cos(ry), 0.0}, {0.0, 0.0, 0.0, 1.0}});
        this.concatenate(trans);
    }

    public void rotateZ(double rz) {
        Transform2hD trans = new Transform2hD(new double[][]{{Math.cos(rz), -Math.sin(rz), 0.0, 0.0}, {Math.sin(rz), Math.cos(rz), 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}});
        this.concatenate(trans);
    }

    public void scale(double mx, double my, double mz) {
        Transform2hD trans = new Transform2hD(new double[][]{{mx, 0.0, 0.0, 0.0}, {0.0, my, 0.0, 0.0}, {0.0, 0.0, mz, 0.0}, {0.0, 0.0, 0.0, 1.0}});
        this.concatenate(trans);
    }

    public void addProjection(int projection) {
        this.projection = projection == 1 ? PROJ_PARALLEL : (projection == 2 ? PROJ_CENTRAL : (projection == 3 ? PROJ_OPTICAL : 0));
    }

    public void removeProjection() {
        this.projection = 0;
    }

    public double[] transform(double x, double y, double z) {
        double xd = this.a[0][0] * x + this.a[0][1] * y + this.a[0][2] * z + this.a[0][3];
        double yd = this.a[1][0] * x + this.a[1][1] * y + this.a[1][2] * z + this.a[1][3];
        double zd = this.a[2][0] * x + this.a[2][1] * y + this.a[2][2] * z + this.a[2][3];
        if (this.projection == 0) {
            return new double[]{xd, yd, zd};
        }
        if (this.projection == PROJ_PARALLEL) {
            if (zd < -1.0) {
                return new double[]{xd, yd};
            }
            return null;
        }
        if (this.projection == PROJ_CENTRAL) {
            if (zd < -1.0) {
                return new double[]{xd / zd, yd / zd};
            }
            return null;
        }
        if (this.projection == PROJ_OPTICAL) {
            if (zd < -1.0) {
                return new double[]{-xd / zd, -yd / zd};
            }
            return null;
        }
        return null;
    }

    public double[] inverseTransform(double x, double y) {
        return this.inverseTransform(x, y, 1.0);
    }

    public double[] inverseTransform(double x, double y, double z) {
        if (this.changed) {
            this.inverseMatrix();
        }
        return this.inverse.transform(x, y, z);
    }

    private void inverseMatrix() {
        Matrix A = new Matrix(this.a);
        Matrix INV = A.inverse();
        this.inverse = new Transform2hD(INV.getArray());
        this.changed = false;
    }

    public String toString() {
        String s = "";
        int i = 0;
        while (i < this.a.length) {
            s = String.valueOf(s) + "[" + this.rnd(this.a[i][0]) + " " + this.rnd(this.a[i][1]) + " " + this.rnd(this.a[i][2]) + " " + this.rnd(this.a[i][3]) + "]\n";
            ++i;
        }
        return s;
    }

    private double rnd(double x) {
        return Math.rint(x / eps) * eps;
    }
}

