/*
 * Decompiled with CFR 0.152.
 */
package hsbogi.transform;

import Jama.Matrix;
import hsbogi.transform.BilinearTransform;
import hsbogi.transform.Transform2hD;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import java.util.Set;

public class TransformFactory {
    public static double DeviceFrame = 10.0;

    public static AffineTransform createSimpleWorldToDevice(Rectangle2D world, Dimension device) {
        try {
            double tx = world.getCenterX();
            double ty = world.getCenterY();
            double mx = (device.getWidth() - 2.0 * DeviceFrame) / world.getWidth();
            double my = (device.getHeight() - 2.0 * DeviceFrame) / world.getHeight();
            double m = Math.min(my, mx);
            double wx = device.getWidth() / 2.0;
            double wy = device.getHeight() / 2.0;
            AffineTransform at = new AffineTransform();
            at.translate(wx, wy);
            at.scale(m, -m);
            at.translate(-tx, -ty);
            return at;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static AffineTransform createSimpleWorldToDevice(Rectangle2D world, double alpha, Dimension device) {
        try {
            double tx = world.getCenterX();
            double ty = world.getCenterY();
            AffineTransform rotation = new AffineTransform();
            rotation.rotate(alpha);
            Path2D.Double worldPath = new Path2D.Double(world, rotation);
            world = worldPath.getBounds2D();
            double mx = (device.getWidth() - 2.0 * DeviceFrame) / world.getWidth();
            double my = (device.getHeight() - 2.0 * DeviceFrame) / world.getHeight();
            double m = Math.min(my, mx);
            double wx = device.getWidth() / 2.0;
            double wy = device.getHeight() / 2.0;
            AffineTransform at = new AffineTransform();
            at.translate(wx, wy);
            at.scale(m, -m);
            at.rotate(alpha);
            at.translate(-tx, -ty);
            return at;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static BilinearTransform create4Parameter(Map<Point2D, Point2D> points) {
        int npts = points.size();
        try {
            if (npts < 2) {
                throw new Exception("Number of points less than two!");
            }
            double[][] x = new double[npts * 2][4];
            double[] y = new double[npts * 2];
            Set<Point2D> keys = points.keySet();
            Point2D[] pa = new Point2D[npts];
            keys.toArray(pa);
            int i = 0;
            while (i < npts) {
                x[2 * i + 0][0] = pa[i].getX();
                x[2 * i + 0][1] = -pa[i].getY();
                x[2 * i + 0][2] = 1.0;
                x[2 * i + 0][3] = 0.0;
                x[2 * i + 1][0] = pa[i].getY();
                x[2 * i + 1][1] = pa[i].getX();
                x[2 * i + 1][2] = 0.0;
                x[2 * i + 1][3] = 1.0;
                Point2D pe = points.get(pa[i]);
                y[2 * i + 0] = pe.getX();
                y[2 * i + 1] = pe.getY();
                ++i;
            }
            double[] z = TransformFactory.solveEquations(x, y);
            return new BilinearTransform(z[0], z[1], z[2], z[3]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static BilinearTransform create6Parameter(Map<Point2D, Point2D> points) {
        int npts = points.size();
        try {
            if (npts < 3) {
                throw new Exception("Number of points less than three!");
            }
            double[][] x = new double[npts * 2][6];
            double[] y = new double[npts * 2];
            Set<Point2D> keys = points.keySet();
            Point2D[] pa = new Point2D[npts];
            keys.toArray(pa);
            int i = 0;
            while (i < npts) {
                x[2 * i + 0][0] = pa[i].getX();
                x[2 * i + 0][1] = 0.0;
                x[2 * i + 0][2] = pa[i].getY();
                x[2 * i + 0][3] = 0.0;
                x[2 * i + 0][4] = 1.0;
                x[2 * i + 0][5] = 0.0;
                x[2 * i + 1][0] = 0.0;
                x[2 * i + 1][1] = pa[i].getX();
                x[2 * i + 1][2] = 0.0;
                x[2 * i + 1][3] = pa[i].getY();
                x[2 * i + 1][4] = 0.0;
                x[2 * i + 1][5] = 1.0;
                Point2D pe = points.get(pa[i]);
                y[2 * i + 0] = pe.getX();
                y[2 * i + 1] = pe.getY();
                ++i;
            }
            double[] z = TransformFactory.solveEquations(x, y);
            return new BilinearTransform(z[0], z[1], z[2], z[3], z[4], z[5]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static BilinearTransform create8Parameter(Map<Point2D, Point2D> points) {
        int npts = points.size();
        try {
            if (npts < 4) {
                throw new Exception("Number of points less than four!");
            }
            double[][] x = new double[npts * 2][8];
            double[] y = new double[npts * 2];
            Set<Point2D> keys = points.keySet();
            Point2D[] pa = new Point2D[npts];
            keys.toArray(pa);
            int i = 0;
            while (i < npts) {
                double xy = pa[i].getX() * pa[i].getY();
                x[2 * i + 0][0] = pa[i].getX();
                x[2 * i + 0][1] = 0.0;
                x[2 * i + 0][2] = pa[i].getY();
                x[2 * i + 0][3] = 0.0;
                x[2 * i + 0][4] = 1.0;
                x[2 * i + 0][5] = 0.0;
                x[2 * i + 0][6] = xy;
                x[2 * i + 0][7] = 0.0;
                x[2 * i + 1][0] = 0.0;
                x[2 * i + 1][1] = pa[i].getX();
                x[2 * i + 1][2] = 0.0;
                x[2 * i + 1][3] = pa[i].getY();
                x[2 * i + 1][4] = 0.0;
                x[2 * i + 1][5] = 1.0;
                x[2 * i + 1][6] = 0.0;
                x[2 * i + 1][7] = xy;
                Point2D pe = points.get(pa[i]);
                y[2 * i + 0] = pe.getX();
                y[2 * i + 1] = pe.getY();
                ++i;
            }
            double[] z = TransformFactory.solveEquations(x, y);
            return new BilinearTransform(z[0], z[1], z[2], z[3], z[4], z[5], z[6], z[7]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static double[] solveEquations(double[][] x, double[] y) {
        Matrix X = new Matrix(x);
        double[][] my = new double[y.length][1];
        int i = 0;
        while (i < y.length) {
            my[i][0] = y[i];
            ++i;
        }
        Matrix Y = new Matrix(my);
        Matrix Z = X.solve(Y);
        double[] z = Z.getColumnPackedCopy();
        return z;
    }

    public static Transform2hD createPerspective(double posx, double posy, double posz, double dist, double decl, double azim) {
        Transform2hD result = new Transform2hD();
        result.translate(-posx, -posy, -posz);
        result.rotateZ(Math.toRadians(azim));
        result.rotateX(Math.toRadians(-decl));
        result.translate(0.0, 0.0, -dist);
        result.addProjection(Transform2hD.PROJ_OPTICAL);
        return result;
    }

    public static Transform2hD createPerspective(double mh, double posx, double posy, double posz, double dist, double decl, double azim) {
        Transform2hD result = new Transform2hD();
        result.scale(1.0, 1.0, mh);
        result.translate(-posx, -posy, -posz);
        result.rotateZ(Math.toRadians(azim));
        result.rotateX(Math.toRadians(-decl));
        result.translate(0.0, 0.0, -dist);
        result.addProjection(Transform2hD.PROJ_OPTICAL);
        return result;
    }

    public static Transform2hD[] createPseudo3D(double mh, double baseline, double posx, double posy, double posz, double dist, double decl, double azim) {
        Transform2hD left = new Transform2hD();
        left.scale(1.0, 1.0, mh);
        left.translate(-posx, -posy, -posz);
        left.rotateZ(Math.toRadians(azim));
        left.rotateX(Math.toRadians(-decl));
        left.translate(baseline / 2.0, 0.0, 0.0);
        left.translate(0.0, 0.0, -dist);
        left.addProjection(Transform2hD.PROJ_OPTICAL);
        Transform2hD right = new Transform2hD();
        right.scale(1.0, 1.0, mh);
        right.translate(-posx, -posy, -posz);
        right.rotateZ(Math.toRadians(azim));
        right.rotateX(Math.toRadians(-decl));
        right.translate(-baseline / 2.0, 0.0, 0.0);
        right.translate(0.0, 0.0, -dist);
        right.addProjection(Transform2hD.PROJ_OPTICAL);
        return new Transform2hD[]{left, right};
    }
}

