/*
 * Decompiled with CFR 0.152.
 */
package hsbogi.transform.demo;

import hsbogi.transform.BilinearTransform;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BilinearDemoFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JLabel jLabelTx = null;
    private JSlider jSliderTx = null;
    private JLabel jLabelTy = null;
    private JSlider jSliderTy = null;
    private JLabel jLabelM = null;
    private JSlider jSliderM = null;
    private JLabel jLabelR = null;
    private JSlider jSliderR = null;
    private JLabel jLabelSx = null;
    private JSlider jSliderSx = null;
    private JLabel jLabelSy = null;
    private JSlider jSliderSy = null;
    private JLabel jLabelBx = null;
    private JSlider jSliderBx = null;
    private JLabel jLabelBy = null;
    private JSlider jSliderBy = null;
    private JPanel jPanel = null;
    Shape[] shapes = this.shapesInitialize();
    BilinearTransform bt0 = null;
    BilinearTransform bt = null;
    double tx = 0.0;
    double ty = 0.0;
    double m = 1.0;
    double r = 0.0;
    double sx = 0.0;
    double sy = 0.0;
    double bx = 0.0;
    double by = 0.0;

    public BilinearDemoFrame() {
        this.initialize();
    }

    private void initialize() {
        this.setSize(800, 600);
        this.setContentPane(this.getJContentPane());
        this.setTitle("BilinearTransform Demo");
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jLabelBy = new JLabel();
            this.jLabelBy.setBounds(new Rectangle(15, 406, 199, 16));
            this.jLabelBy.setText("Konvergenz y");
            this.jLabelBx = new JLabel();
            this.jLabelBx.setBounds(new Rectangle(15, 350, 199, 16));
            this.jLabelBx.setText("Konvergenz x");
            this.jLabelSy = new JLabel();
            this.jLabelSy.setBounds(new Rectangle(15, 294, 199, 16));
            this.jLabelSy.setText("Scherung y");
            this.jLabelSx = new JLabel();
            this.jLabelSx.setBounds(new Rectangle(15, 238, 199, 16));
            this.jLabelSx.setText("Scherung x");
            this.jLabelR = new JLabel();
            this.jLabelR.setBounds(new Rectangle(15, 182, 199, 16));
            this.jLabelR.setText("Drehung");
            this.jLabelM = new JLabel();
            this.jLabelM.setBounds(new Rectangle(15, 126, 199, 16));
            this.jLabelM.setText("Ma\u00dfstab");
            this.jLabelTy = new JLabel();
            this.jLabelTy.setBounds(new Rectangle(15, 70, 199, 16));
            this.jLabelTy.setText("Verschiebung y");
            this.jLabelTx = new JLabel();
            this.jLabelTx.setBounds(new Rectangle(15, 14, 199, 16));
            this.jLabelTx.setText("Verschiebung x");
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(null);
            this.jContentPane.add((Component)this.jLabelTx, null);
            this.jContentPane.add((Component)this.getJSliderTx(), null);
            this.jContentPane.add((Component)this.jLabelTy, null);
            this.jContentPane.add((Component)this.getJSliderTy(), null);
            this.jContentPane.add((Component)this.jLabelM, null);
            this.jContentPane.add((Component)this.getJSliderM(), null);
            this.jContentPane.add((Component)this.jLabelR, null);
            this.jContentPane.add((Component)this.getJSliderR(), null);
            this.jContentPane.add((Component)this.jLabelSx, null);
            this.jContentPane.add((Component)this.getJSliderSx(), null);
            this.jContentPane.add((Component)this.jLabelSy, null);
            this.jContentPane.add((Component)this.getJSliderSy(), null);
            this.jContentPane.add((Component)this.jLabelBx, null);
            this.jContentPane.add((Component)this.getJSliderBx(), null);
            this.jContentPane.add((Component)this.jLabelBy, null);
            this.jContentPane.add((Component)this.getJSliderBy(), null);
            this.jContentPane.add((Component)this.getJPanel(), null);
        }
        return this.jContentPane;
    }

    private JSlider getJSliderTx() {
        if (this.jSliderTx == null) {
            this.jSliderTx = new JSlider();
            this.jSliderTx.setBounds(new Rectangle(15, 42, 199, 16));
            this.jSliderTx.setMinimum(0);
            this.jSliderTx.setMaximum(100);
            this.jSliderTx.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    int sv = BilinearDemoFrame.this.jSliderTx.getValue();
                    BilinearDemoFrame.this.tx = (double)(sv - 50) * 0.5;
                    BilinearDemoFrame.this.jLabelTx.setText("Verschiebung x: " + BilinearDemoFrame.this.rnd5(BilinearDemoFrame.this.tx));
                }
            });
            this.jSliderTx.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    BilinearDemoFrame.this.bt.translate(BilinearDemoFrame.this.tx, 0.0);
                    BilinearDemoFrame.this.repaint();
                }
            });
        }
        return this.jSliderTx;
    }

    private JSlider getJSliderTy() {
        if (this.jSliderTy == null) {
            this.jSliderTy = new JSlider();
            this.jSliderTy.setBounds(new Rectangle(15, 98, 199, 16));
            this.jSliderTy.setMinimum(0);
            this.jSliderTy.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    int sv = BilinearDemoFrame.this.jSliderTy.getValue();
                    BilinearDemoFrame.this.ty = (double)(sv - 50) * 0.5;
                    BilinearDemoFrame.this.jLabelTy.setText("Verschiebung y: " + BilinearDemoFrame.this.rnd5(BilinearDemoFrame.this.ty));
                }
            });
            this.jSliderTy.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    BilinearDemoFrame.this.bt.translate(0.0, BilinearDemoFrame.this.ty);
                    BilinearDemoFrame.this.repaint();
                }
            });
        }
        return this.jSliderTy;
    }

    private JSlider getJSliderM() {
        if (this.jSliderM == null) {
            this.jSliderM = new JSlider();
            this.jSliderM.setBounds(new Rectangle(15, 154, 199, 16));
            this.jSliderM.setMinimum(0);
            this.jSliderM.setName("");
            this.jSliderM.setMaximum(100);
            this.jSliderM.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    int sv = BilinearDemoFrame.this.jSliderM.getValue();
                    BilinearDemoFrame.this.m = (double)sv * 0.02;
                    BilinearDemoFrame.this.jLabelM.setText("Ma\u00dfstab: " + BilinearDemoFrame.this.rnd5(BilinearDemoFrame.this.m));
                }
            });
            this.jSliderM.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    BilinearDemoFrame.this.bt.scale(BilinearDemoFrame.this.m, BilinearDemoFrame.this.m);
                    BilinearDemoFrame.this.repaint();
                }
            });
        }
        return this.jSliderM;
    }

    private JSlider getJSliderR() {
        if (this.jSliderR == null) {
            this.jSliderR = new JSlider();
            this.jSliderR.setBounds(new Rectangle(15, 210, 199, 16));
            this.jSliderR.setMinimum(0);
            this.jSliderR.setMaximum(100);
            this.jSliderR.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    int sv = BilinearDemoFrame.this.jSliderR.getValue();
                    BilinearDemoFrame.this.r = sv - 50;
                    BilinearDemoFrame.this.jLabelR.setText("Drehung: " + BilinearDemoFrame.this.rnd5(BilinearDemoFrame.this.r) + "\u00b0");
                }
            });
            this.jSliderR.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    BilinearDemoFrame.this.bt.rotate(Math.toRadians(BilinearDemoFrame.this.r), 0.0, 0.0);
                    BilinearDemoFrame.this.repaint();
                }
            });
        }
        return this.jSliderR;
    }

    private JSlider getJSliderSx() {
        if (this.jSliderSx == null) {
            this.jSliderSx = new JSlider();
            this.jSliderSx.setBounds(new Rectangle(15, 266, 199, 16));
            this.jSliderSx.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    int sv = BilinearDemoFrame.this.jSliderSx.getValue();
                    BilinearDemoFrame.this.sx = (double)(sv - 50) * 0.01;
                    BilinearDemoFrame.this.jLabelSx.setText("Scherung x: " + BilinearDemoFrame.this.rnd5(BilinearDemoFrame.this.sx));
                }
            });
            this.jSliderSx.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    BilinearDemoFrame.this.bt.shear(BilinearDemoFrame.this.sx, 0.0);
                    BilinearDemoFrame.this.repaint();
                }
            });
        }
        return this.jSliderSx;
    }

    private JSlider getJSliderSy() {
        if (this.jSliderSy == null) {
            this.jSliderSy = new JSlider();
            this.jSliderSy.setBounds(new Rectangle(15, 322, 199, 16));
            this.jSliderSy.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    int sv = BilinearDemoFrame.this.jSliderSy.getValue();
                    BilinearDemoFrame.this.sy = (double)(sv - 50) * 0.01;
                    BilinearDemoFrame.this.jLabelSy.setText("Scherung y: " + BilinearDemoFrame.this.rnd5(BilinearDemoFrame.this.sy));
                }
            });
            this.jSliderSy.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    BilinearDemoFrame.this.bt.shear(0.0, BilinearDemoFrame.this.sy);
                    BilinearDemoFrame.this.repaint();
                }
            });
        }
        return this.jSliderSy;
    }

    private JSlider getJSliderBx() {
        if (this.jSliderBx == null) {
            this.jSliderBx = new JSlider();
            this.jSliderBx.setBounds(new Rectangle(15, 378, 199, 16));
            this.jSliderBx.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    int sv = BilinearDemoFrame.this.jSliderBx.getValue();
                    BilinearDemoFrame.this.bx = (double)(sv - 50) * 1.0E-4;
                    BilinearDemoFrame.this.jLabelBx.setText("Konvergenz x: " + BilinearDemoFrame.this.rnd5(BilinearDemoFrame.this.bx));
                }
            });
            this.jSliderBx.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    BilinearDemoFrame.this.bt.converge(BilinearDemoFrame.this.bx, 0.0);
                    BilinearDemoFrame.this.repaint();
                }
            });
        }
        return this.jSliderBx;
    }

    private JSlider getJSliderBy() {
        if (this.jSliderBy == null) {
            this.jSliderBy = new JSlider();
            this.jSliderBy.setBounds(new Rectangle(15, 434, 199, 16));
            this.jSliderBy.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    int sv = BilinearDemoFrame.this.jSliderBy.getValue();
                    BilinearDemoFrame.this.by = (double)(sv - 50) * 1.0E-4;
                    BilinearDemoFrame.this.jLabelBy.setText("Konvergenz y: " + BilinearDemoFrame.this.rnd5(BilinearDemoFrame.this.by));
                }
            });
            this.jSliderBy.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    BilinearDemoFrame.this.bt.converge(0.0, BilinearDemoFrame.this.by);
                    BilinearDemoFrame.this.repaint();
                }
            });
        }
        return this.jSliderBy;
    }

    private Shape[] shapesInitialize() {
        int n = 5;
        int k = 0;
        Shape[] shapes = new Shape[n * n];
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                shapes[k++] = new Ellipse2D.Double(50.0 * ((double)i - (double)n / 2.0), 50.0 * ((double)j - (double)n / 2.0), 50.0, 50.0);
                ++j;
            }
            ++i;
        }
        return shapes;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel(){
                private static final long serialVersionUID = 1L;

                @Override
                public void paint(Graphics g) {
                    Graphics2D g2 = (Graphics2D)g;
                    int wh = this.getWidth() / 2;
                    int hh = this.getHeight() / 2;
                    g2.scale(1.0, -1.0);
                    g2.translate(wh, -hh);
                    if (BilinearDemoFrame.this.bt == null) {
                        BilinearDemoFrame.this.bt = new BilinearTransform();
                    }
                    g2.setColor(new Color(255, 0, 0, 128));
                    int i = 0;
                    while (i < BilinearDemoFrame.this.shapes.length) {
                        g2.fill(BilinearDemoFrame.this.shapes[i]);
                        ++i;
                    }
                    g2.setColor(new Color(0, 0, 255, 128));
                    i = 0;
                    while (i < BilinearDemoFrame.this.shapes.length) {
                        g2.fill(BilinearDemoFrame.this.bt.transform(BilinearDemoFrame.this.shapes[i]));
                        ++i;
                    }
                }
            };
            this.jPanel.setLayout(null);
            this.jPanel.setBounds(new Rectangle(240, 2, 623, 562));
        }
        return this.jPanel;
    }

    private double rnd5(double v) {
        return Math.rint(v * 100000.0) / 100000.0;
    }
}

