/*
 * Decompiled with CFR 0.152.
 */
package hsbogi.transform.demo;

import hsbogi.transform.BilinearTransform;
import hsbogi.transform.TransformFactory;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;

public class GeoreferenceDemo {
    public static void main(String[] args) {
        GeoreferenceDemo.get4ParTrafo();
    }

    public static void get4ParTrafo() {
        Point2D[] src = GeoreferenceDemo.generatePoints(10, 1000.0, 1000.0);
        BilinearTransform bt = new BilinearTransform();
        bt.rotate(Math.toRadians(10.0), 500.0, 500.0);
        bt.translate(200.0, 400.0);
        bt.scale(2.0, 2.0);
        System.out.println(bt);
        Point2D[] dst = GeoreferenceDemo.transformRandom(src, bt, 0.1);
        Map map = GeoreferenceDemo.getMap(src, dst);
        BilinearTransform georef = TransformFactory.create4Parameter(map);
        System.out.println(georef);
        Point2D[] geodst = GeoreferenceDemo.transform(src, georef);
        GeoreferenceDemo.printStatistics(dst, geodst);
    }

    public static Point2D[] generatePoints(int n, double dx, double dy) {
        Point2D[] points = new Point2D[n];
        points[0] = new Point2D.Double(0.0, 0.0);
        points[1] = new Point2D.Double(dx, 0.0);
        points[2] = new Point2D.Double(0.0, dy);
        points[3] = new Point2D.Double(dx, dy);
        int i = 4;
        while (i < points.length) {
            points[i] = new Point2D.Double(Math.random() * dx, Math.random() * dy);
            ++i;
        }
        return points;
    }

    public static Point2D[] transform(Point2D[] src, BilinearTransform bt) {
        Point2D[] dst = new Point2D[src.length];
        int i = 0;
        while (i < src.length) {
            dst[i] = bt.transform(src[i]);
            ++i;
        }
        return dst;
    }

    public static Point2D[] transformRandom(Point2D[] src, BilinearTransform bt, double rand) {
        Point2D[] dst = new Point2D[src.length];
        int i = 0;
        while (i < src.length) {
            dst[i] = bt.transform(src[i]);
            double rx = (Math.random() - Math.random()) * rand;
            double ry = (Math.random() - Math.random()) * rand;
            dst[i].setLocation(dst[i].getX() + rx, dst[i].getY() + ry);
            ++i;
        }
        return dst;
    }

    public static Map getMap(Point2D[] src, Point2D[] dst) {
        HashMap<Point2D, Point2D> map = new HashMap<Point2D, Point2D>();
        int i = 0;
        while (i < src.length) {
            map.put(src[i], dst[i]);
            ++i;
        }
        return map;
    }

    public static void printStatistics(Point2D[] orig, Point2D[] trans) {
        double sigmaX = 0.0;
        double sigmaY = 0.0;
        double c = 1000.0;
        int i = 0;
        while (i < orig.length) {
            double dx = Math.rint((orig[i].getX() - trans[i].getX()) * c) / c;
            double dy = Math.rint((orig[i].getY() - trans[i].getY()) * c) / c;
            sigmaX += dx * dx;
            sigmaY += dy * dy;
            System.out.println(String.valueOf(dx) + " " + dy);
            ++i;
        }
        sigmaX = Math.sqrt(sigmaX / (double)orig.length);
        sigmaY = Math.sqrt(sigmaY / (double)orig.length);
        System.out.println("\n" + sigmaX + " " + sigmaY);
    }
}

