/*
 * Decompiled with CFR 0.152.
 */
package hsbogi.transform.demo;

import hsbogi.transform.Point2hD;
import hsbogi.transform.Shape2hD;
import hsbogi.transform.demo.SimpleLine2hD;
import hsbogi.transform.demo.SimplePoint2hD;

public class SpatialDataGenerator {
    static double[][] fr = null;
    static double[][] fi = null;
    static int di = 0;
    static int dj = 0;

    public static Shape2hD[] createGrid2hd(int n, double hf) {
        int j;
        int k = 0;
        SpatialDataGenerator.createFourierFactors(n, hf / 3.0);
        Point2hD[][] pts = new Point2hD[n + 1][n + 1];
        int i = 0;
        while (i < n + 1) {
            j = 0;
            while (j < n + 1) {
                double z = SpatialDataGenerator.linearTrend(i, j, n, 3.0 * hf) + SpatialDataGenerator.createFourier(i, j, n) + SpatialDataGenerator.rand(hf / 15.0);
                pts[i][j] = new SimplePoint2hD((i - n / 2) * 25, (j - n / 2) * 25, z);
                ++j;
            }
            ++i;
        }
        Shape2hD[] shapes = new Shape2hD[2 * (n + 1) * (n + 1)];
        int i2 = 0;
        while (i2 < n) {
            int j2 = 0;
            while (j2 < n) {
                shapes[k++] = new SimpleLine2hD(pts[i2][j2], pts[i2][j2 + 1]);
                shapes[k++] = new SimpleLine2hD(pts[i2][j2], pts[i2 + 1][j2]);
                ++j2;
            }
            ++i2;
        }
        j = 0;
        while (j < n) {
            shapes[k++] = new SimpleLine2hD(pts[n][j], pts[n][j + 1]);
            shapes[k++] = new SimpleLine2hD(pts[j][n], pts[j + 1][n]);
            ++j;
        }
        return shapes;
    }

    public static Shape2hD[] createGrid2hd(int n, double dxy, double hf) {
        int j;
        int k = 0;
        SpatialDataGenerator.createFourierFactors(n, hf / 3.0);
        Point2hD[][] pts = new Point2hD[n + 1][n + 1];
        int i = 0;
        while (i < n + 1) {
            j = 0;
            while (j < n + 1) {
                double z = SpatialDataGenerator.linearTrend(i, j, n, 3.0 * hf) + SpatialDataGenerator.createFourier(i, j, n) + SpatialDataGenerator.rand(hf / 15.0);
                pts[i][j] = new SimplePoint2hD((double)(i - n / 2) * dxy, (double)(j - n / 2) * dxy, z);
                ++j;
            }
            ++i;
        }
        Shape2hD[] shapes = new Shape2hD[2 * (n + 1) * (n + 1)];
        int i2 = 0;
        while (i2 < n) {
            int j2 = 0;
            while (j2 < n) {
                shapes[k++] = new SimpleLine2hD(pts[i2][j2], pts[i2][j2 + 1]);
                shapes[k++] = new SimpleLine2hD(pts[i2][j2], pts[i2 + 1][j2]);
                ++j2;
            }
            ++i2;
        }
        j = 0;
        while (j < n) {
            shapes[k++] = new SimpleLine2hD(pts[n][j], pts[n][j + 1]);
            shapes[k++] = new SimpleLine2hD(pts[j][n], pts[j + 1][n]);
            ++j;
        }
        return shapes;
    }

    private static void createFourierFactors(int n, double factor) {
        int m = n / 10;
        fr = new double[m][m];
        fi = new double[m][m];
        int i = 0;
        while (i < m) {
            int j = 0;
            while (j < m) {
                double phase = (Math.random() - Math.random()) * 2.0 * Math.PI;
                SpatialDataGenerator.fr[i][j] = factor / Math.pow(1.5, i + j) * Math.cos(phase);
                SpatialDataGenerator.fi[i][j] = factor / Math.pow(1.5, i + j) * Math.sin(phase);
                ++j;
            }
            ++i;
        }
        di = n * (int)(Math.random() - Math.random());
        dj = n * (int)(Math.random() - Math.random());
    }

    private static double createFourier(int i, int j, int n) {
        int m = fr.length;
        double z = 0.0;
        double pi = (double)(2 * (i - di)) * Math.PI / (double)n;
        double pj = (double)(2 * (j - dj)) * Math.PI / (double)n;
        int im = 0;
        while (im < m) {
            int jm = 0;
            while (jm < m) {
                z = z + fr[im][jm] * Math.cos((double)im * pi) * Math.cos((double)jm * pj) + fi[im][jm] * Math.sin((double)im * pi) * Math.sin((double)jm * pj);
                ++jm;
            }
            ++im;
        }
        return z;
    }

    private static double linearTrend(int i, int j, int n, double factor) {
        return (double)i * 1.0 / (double)n * ((double)j * 1.0 / (double)n) * factor;
    }

    private static double rand(double x) {
        return x * (Math.random() - Math.random());
    }
}

